clear all;
global_vars;

CHOICE = 6; % This number should be an interger between 1 and 6
            % 1 for channel_cavity_1, 2 for channel_cavity_2, 3 for channel_cavity_3,
            % 4 for channel_cavity_4, 5 for channel_obstacle, 6 for boeing737b3

if CHOICE == 1
    load channel_cavity_1.mat;
    set_bdy_velocity(1);
elseif CHOICE == 2
    load channel_cavity_2.mat;
    set_bdy_velocity(1);
elseif CHOICE == 3
    load channel_cavity_3.mat;
    set_bdy_velocity(1);
elseif CHOICE == 4
    load channel_cavity_4.mat;
    set_bdy_velocity(5);
elseif CHOICE == 5
    load channel_obstacle;
    set_bdy_velocity(1);
elseif CHOICE == 6
    load boeing737b3.mat;
    set_boeing_velocity;
end

routine_settings; % Run a routine to set up all the necessary global variables when mesh is given.

viscosity = 1;
u_node_force = set_force_constant([0,-1]);

[lap_u_bi,lap_u_lin,grad_p_bi,grad_p_lin,div_u_bi,div_u_lin,force_u_lin]=discrete_operator;

K=zeros(n_u_node_dof+n_p_node_dof+1,n_u_node_dof+n_p_node_dof);
K(1:n_u_node_dof,1:n_u_node_dof)=viscosity*lap_u_bi;
K(1:n_u_node_dof,n_u_node_dof+1:n_u_node_dof+n_p_node_dof)= - grad_p_bi;
K(n_u_node_dof+1:n_u_node_dof+n_p_node_dof,1:n_u_node_dof)=div_u_bi;
K(n_u_node_dof+n_p_node_dof+1,n_u_node_dof+1)=1;
f=[-force_u_lin-viscosity*lap_u_lin+grad_p_lin;-div_u_lin;0];
sol=K\f;

for k=1:floor(n_u_node_dof/2)
    ith_node=find(u_node_val_to_dof == 2*k-1);
    u_node_val(ith_node,1)=sol(2*k-1);
    u_node_val(ith_node,2)=sol(2*k);
end

for k=1:n_p_node
    p_node_val(k,1)=sol(n_u_node_dof+k);
end

plot_u_val;
plot_p_val;